<?php
include 'header.php';
?>

<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Exam Tips</title>
  
  </head>
  
     <!--Preloader -->
  <div class="preloader flex-column justify-content-center align-items-center">
    <img class="animation__shake" src="cupafavicon.png" alt="CUPA Logo" height="60" width="60">
  </div>

    <!-- Main content -->
    <b><div class="nav-link" id='ct7'></div></b>
    <section class="content mt-5">
      <div class="container-fluid">
 
        <div class="row">
          <div class="col-lg-12 connectedSortable">
            <div class="card">
              <div class="card-header">
                <h4>
                  <i class="fas fa-book-open mr-1"></i>
                  <b>Exam Tips</b>
                </h4>
                <div class="card-tools">
                  
                </div>
              </div><!-- /.card-header -->
              <div class="card-body">
                <div class="tab-content p-0">
                Final exams and semester-end papers are among the most challenging aspects of the college experience. 
                <br><b>There is so much to learn, keep organized, and remember as you head into finals. </b>
                <br>Not every studying technique works for every student, so experiment with a few of these important study tips to find out which ones work best for you.
                <br>
               <ol>

<li><b>Make the Most of Class Time</b></li>
Attend all class sessions, pay close attention to the lectures, and take notes in a way that makes sense for you. The goal is to be able to understand your notes when you review them later.

“Taking good notes means you pay more attention during class,” suggests Peter, a final year student at the Kenyatta University. “When you prepare for the test, it will be really helpful.” And if something does not make sense, raise your hand and ask, or make a note to follow up with your professor or teacher assistant (also known as a TA) after class.

<li><b>Study with Classmates</b></li>
In addition to making friends, forming study groups in each of your classes is a valuable—and fun—way to review for tests. Working together helps develop good study habits, increases collaboration on group projects, and boosts confidence. “Find a partner to compare notes with,” Peter adds. “You can work together, study together, help each other, and push each other to be better.”

<li><b>Take Advantage of Office Hours</b></li>
If you are having trouble with a concept or topic, your professors can help. Stop by during their office hours or email questions to your professor to understand the class material better, gain helpful study tips on how to prepare for your exams or write a better essay. You will also create a relationship with your instructor that could lead to a valuable mentorship.

TIP: If it is written on the board, add it to your notes. It just might be on the test.

<li><b>Create Flashcards</b></li>
One of the top study tips for college students includes rewriting important facts, concepts, and definitions on flashcards. Flashcards also let you quiz yourself without the help of others. Digital flashcards and study apps are another way to organize and review the material.

<li><b>Find a Good Study Spot</b></li>
Some people like the complete silence of a library setting, while others like the stimulation of a busy café. Some students prefer sitting at their desks to study, others like a study spot outside in the sun.

A star student at KU, Peter prefers a quiet spot, away from distractions. “At home, you’ll want to fall asleep or play computer games,” he said. “So, I go to the library to study.” The best study environment for you is the one that feels most productive, so try out a few places to see which works best.

<li><b>Switch It Up</b></li>
Taking too much time on one subject can make you lose your concentration. One of the most important study tips for college exams is to change topics every 30 minutes or so to prevent learning fatigue. Revisit challenging topics once you have given your brain a break.

<li><b>Read and Review—Early and Often</b></li>
According to the Ebbinghaus Forgetting Curve principle, we forget 70% of what we have learned within 24 hours. Going over new ideas a day after class will help increase retention and comprehension—so make time each evening for a quick review. Break chapters into sections and review the material at the end of each before moving on. Make notes by summarizing the critical aspects of the reading so you can easily review them without having to reread entire chapters. Bookmark difficult sections to revisit later.
 
<li><b>Stay Organized</b></li>
Scheduling class meetings, homework, assignments, projects, and study sessions is crucial to staying organized. Use a planner to keep track of deadlines, dates, and times so you do not forget anything important. Check your class syllabus for key dates and plan out the time for a study schedule that works for you.

<li><b>Visualize the Material</b></li>
Focus on the most important parts of your class notes by condensing the material and underlining or highlighting key words and concepts. Not a fan of traditional written notes? Try reformatting them into charts, diagrams, mind maps, or outlines to create visuals that can help you make sense of complex concepts.

<li><b>Find a Tutor</b></li>
Tutors are available on most college campuses and are typically fellow students who specialize in or excel at a given topic. If you are a student at a RVIBS, talk to your Student Service Advisor about our special academic support services for students.

<li><b>Focus on Understanding</b></li>
Memorizing means finding ways to remember and repeat facts. Understanding goes a little deeper, and means you can apply new knowledge to various scenarios and know how it relates to other concepts. College exams often test understanding, not just memorization.

<li><b>Attend the Review Session</b></li>
If your professor or teacher assistant is offering a pre-test review session before finals week, make sure to attend. This is where you can learn important information on the format of the exam and what may be covered in the questions, as well as key topics to focus your studies.

TIP: Final exams and midterms tend to count heavily toward your final average, whereas classwork, papers, and quizzes tend to factor in less. Check your syllabus to find out how your college exams will affect your final grade.

<li><b>Stay Focused</b></li>
Keeping your mind on track can be as simple as taking a break from your phone and your friends. Put on some instrumental music or noise-canceling headphones and put your mobile on airplane mode to help you focus on your studies.

<li><b>Take Breaks</b></li>
Give your brain and body a chance to refresh so you can approach the material with energy and focus. According to Oxford Learning, “for every 30 minutes you study, take a short 10–15-minute break to recharge. Short study sessions are more effective and help you make the most of your study time.” So, stand up, stretch your legs, and get some fresh air before getting back to the books.

TIP: Exercise increases blood flow to the brain, which can give you more energy and better comprehension. A yoga or stretching session can help with concentration and focus.

<li><b>Take Good Care of Yourself</b></li>
Filling up on junk food to save time is not the smartest strategy for studying. Instead, keep a balanced diet of “brain foods” like fresh fruits and vegetables, balanced with protein and healthy fats to fuel your mind. The same goes for sleep: Plan to get a good night’s rest the night before the exam.

<li><b>Pace Yourself</b></li>
Cramming in all your studying during finals week can lead to burnout and anxiety. Split the material into topics and review in stages to fully absorb information into real understanding (see tip 11). The night before, write out a few key ideas to look over before the exam.

If you take a one-hour class, you need to take two extra hours out of the classroom to study. So, if you’re taking 15 hours a week, you need to have 30 hours to study after class.

<li><b>Take the Right Approach</b></li>
Different types of college exams require different study approaches. Multiple choice means focusing on definitions and concepts. Essay tests require you to exhibit a conceptual understanding of the material. Ask your professor about the format of the exam so you know how to prepare.

<li><b>Learn by Teaching Others</b></li>
Explaining concepts to a classmate is a great way to make sure you really understand the material yourself—and to help them learn as well. When you find new ways to explain a concept, you are mastering the information by processing it for others.

<li><b>Have Fun with Words</b></li>
Breaking down the material into small pieces and creating acronyms, phrases, rhymes, or metaphors can be a valuable—and fun—way to memorize concepts. For example, students studying business strategies will remember acronyms like “POGO SQUINT”:
No matter how silly, this method can help you remember important concepts for your exams. Share your useful acronyms and rhymes with your study group to give other students interesting and unexpected study techniques.

<li><b>Test Your Knowledge</b></li>
Once you know the format, try creating a practice exam based on what you think the test might cover. This will help you understand the material on a deeper level, and guide what you should be studying. You can then use your practice exam to quiz yourself and your study group.

<li><b>Reward Yourself</b></li>
Good study habits are hard work! Treat yourself to breaks and little rewards to keep you going. Healthy snacks, nice walks outside, or even an episode of your favorite TV show are good ways to keep you motivated.
<br><br>
Knowing your own effective study strategies is key to success in your college career, and will help with career projects and presentations after graduation, too. Finding the study tips that work best for you will save you time and energy and earn you the best results.
                
                </ol>
                
                <button class="btn bg-primary mr-auto"> <a href="dashboard.php">Go Back</a></button>
                  <div class="chart tab-pane" id="sales-chart" style="position: relative; height: 300px;">
                    <canvas id="sales-chart-canvas" height="300" style="height: 300px;"></canvas>
                  </div>
                </div>
              </div><!-- /.card-body -->
            </div>
        </div>   
       

            
          
           
            <!-- /.card -->
          </section>
          <!-- right col -->
        </div>
        <!-- /.row (main row) -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!--<footer class="row fixed-bottom">-->
  <!--    <div class="col-4 brown mx-auto py-2">-->
  <!--            <center><strong>Copyright &copy; <?php echo date('Y');?> <a href="https://cupa.co.ke">CUPA.co.ke</a>.</strong>-->
  <!--  All rights reserved.</center>-->
  <!--  </div>-->
  <!--</footer>-->
  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<script>
    document.addEventListener("DOMContentLoaded", function(){
  window.addEventListener('scroll', function() {
      if (window.scrollY > 50) {
        document.getElementById('navbar_top').classList.add('fixed-top');
        // add padding top to show content behind navbar
        navbar_height = document.querySelector('.navbar').offsetHeight;
        document.body.style.paddingTop = navbar_height + 'px';
      } else {
        document.getElementById('navbar_top').classList.remove('fixed-top');
         // remove padding top from body
        document.body.style.paddingTop = '0';
      } 
  });
});
</script>

<script src="plugins/jquery/jquery.min.js"></script>
<!-- jQuery UI 1.11.4 -->
<script src="plugins/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button)
</script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- ChartJS -->
<script src="plugins/chart.js/Chart.min.js"></script>
<!-- Sparkline -->
<script src="plugins/sparklines/sparkline.js"></script>
<!-- JQVMap -->
<script src="plugins/jqvmap/jquery.vmap.min.js"></script>
<script src="plugins/jqvmap/maps/jquery.vmap.usa.js"></script>
<!-- jQuery Knob Chart -->
<script src="plugins/jquery-knob/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="plugins/moment/moment.min.js"></script>
<script src="plugins/daterangepicker/daterangepicker.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Summernote -->
<script src="plugins/summernote/summernote-bs4.min.js"></script>
<!-- overlayScrollbars -->
<script src="plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>
</body>
</html>

<script>function display_ct7() {
var x = new Date()
var ampm = x.getHours( ) >= 12 ? ' PM' : ' AM';
hours = x.getHours( ) % 12;
hours = hours ? hours : 12;
hours=hours.toString().length==1? 0+hours.toString() : hours;

var minutes=x.getMinutes().toString()
minutes=minutes.length==1 ? 0+minutes : minutes;

var seconds=x.getSeconds().toString()
seconds=seconds.length==1 ? 0+seconds : seconds;

var month=(x.getMonth() +1).toString();
month=month.length==1 ? 0+month : month;

var dt=x.getDate().toString();
dt=dt.length==1 ? 0+dt : dt;

var x1=month + ":" + dt + ":" + x.getFullYear(); 
x1 = x1 + "  " +  hours + ":" +  minutes + ":" +  seconds + " " + ampm;
document.getElementById('ct7').innerHTML = x1;
display_c7();
 }
 function display_c7(){
var refresh=1000; // Refresh rate in milli seconds
mytime=setTimeout('display_ct7()',refresh)
}
display_c7()
</script>