<?php
include 'header.php';
?>

<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Study Tips</title>
  
  </head>
  
     <!--Preloader -->
  <div class="preloader flex-column justify-content-center align-items-center">
    <img class="animation__shake" src="cupafavicon.png" alt="CUPA Logo" height="60" width="60">
  </div>

    <!-- Main content -->
    <b><div class="nav-link" id='ct7'></div></b>
    <section class="content mt-5">
      <div class="container-fluid">
 
        <div class="row">
          <div class="col-lg-12 connectedSortable">
            <div class="card">
              <div class="card-header">
                <h4>
                  <i class="fas fa-book-open mr-1"></i>
                  <b>Study Tips</b>
                </h4>
                <div class="card-tools">
                  
                </div>
              </div><!-- /.card-header -->
              <div class="card-body">
                <div class="tab-content p-0">
               <ol>
<li><b>Study Smarter Not Harder</b></li>
Do you ever feel like your study habits simply aren’t cutting it? Do you wonder what you could be doing to perform better in class and on exams? Many students realize that their high school study habits aren’t very effective in college. This is understandable, as college is quite different from high school. The professors are less personally involved, classes are bigger, exams are worth more, reading is more intense, and classes are much more rigorous. That doesn’t mean there’s anything wrong with you; it just means you need to learn some more effective study skills. Fortunately, there are many active, effective study strategies that are shown to be effective in college classes.

This handout offers several tips on effective studying. Implementing these tips into your regular study routine will help you to efficiently and effectively learn course material. Experiment with them and find some that work for you.

<li><b>Reading is not studying</b></li>
Simply reading and re-reading texts or notes is not actively engaging in the material. It is simply re-reading your notes. Only ‘doing’ the readings for class is not studying. It is simply doing the reading for class. Re-reading leads to quick forgetting.

<br>Think of reading as an important part of pre-studying, but learning information requires actively engaging in the material. Active engagement is the process of constructing meaning from text that involves making connections to lectures, forming examples, and regulating your own learning. Active studying does not mean highlighting or underlining text, re-reading, or rote memorization. Though these activities may help to keep you engaged in the task, they are not considered active studying techniques and are weakly related to improved learning.

<br>Ideas for active studying include:
<ul>
<li>Create a study guide by topic. Formulate questions and problems and write complete answers. Create your own quiz.</li>
<li>Become a teacher. Say the information aloud in your own words as if you are the instructor and teaching the concepts to a class.</li>
<li>Derive examples that relate to your own experiences.</li>
<li>Create concept maps or diagrams that explain the material.</li>
<li>Develop symbols that represent concepts.</li>
<li>For non-technical classes (e.g., English, History, Psychology), figure out the big ideas so you can explain, contrast, and re-evaluate them.</li>
<li>For technical classes, work the problems and explain the steps and why they work.</li>
<li>Study in terms of question, evidence, and conclusion: What is the question posed by the instructor/author? What is the evidence that they present? What is the conclusion?</li>
<li>Organization and planning will help you to actively study for your courses. When studying for a test, organize your materials first and then begin your active reviewing by topic. Often professors provide subtopics on the syllabi. Use them as a guide to help organize your materials. For example, gather all of the materials for one topic (e.g., PowerPoint notes, text book notes, articles, homework, etc.) and put them together in a pile. Label each pile with the topic and study by topics.
</ul>
<br>Understand the Study Cycle
<br>In the Study Cycle, each step builds on the previous one and distributes your learning throughout the semester, which is much more effective than waiting until the day before the test to study.
<b><br>Step 1: Preview</b><br>
Take a look at what you’ll be covering during lecture before you go to class. This will help you gain a sense of the big picture and anticipate how concepts fit together. You will get more out of attending the lecture (step 2) if you already have some context for what you’re about to learn, and you can come into class with questions that you expect will be answered.</li>

Make sure to do the pre-class reading. Even if your teacher does not specifically assign reading, you can use the course schedule on the syllabus to find out what will be covered and preview the content. If you’re pressed for time, it is okay to skim—focus on headings, introductions, and summary. If your professor provides you with learning objectives or PowerPoint slides ahead of time, make sure to preview those and maybe even print them out to take notes on. The important thing to keep in mind here is that neither skimming, reading, nor attending class is incredibly effective on its own, but the combination (and sometimes repetition) of the two results in good learning. If you’ve heard a friend say “I don’t read for class because the professor covers everything in class,” they’re missing a huge opportunity to learn more from the lecture—meaning they’ll need to study more later in order to learn the material.</li>

<b><br>Step 2: Attend class</b><br>

Of course, going to class is an important step in the study cycle, but just being physically present isn’t enough. Being attentive and engaged will help you get the most out of the experience. Class time is important, because this is when you get an understanding of the professor’s expectations and areas of focus (e.g., what’s going to be on the test), which will help you figure out what to focus on during your study sessions later (steps 3 and 4). It’s also a great opportunity to gain insight and intuition from your instructor and from other students in your class through asking questions and taking part in discussions.</li>

During class, take notes in a way that will be useful to you. Taking notes by hand can help you remember the information—especially if you try to paraphrase in your own words. Try to stay off your phone/computer during class, unless you need it for an assignment. Keep track of your questions, and if you don’t get to ask them during class, make a plan to go to office hours or tutoring.</li>

<b><br>Step 3: Review</b><br>
Take some time after class to go back over your notes. You don’t have to spend a long time doing this, but the sooner you do it the better. By reviewing soon after class, while the material is still fresh, you can fill in gaps and figure out what you might need help with.

When you’re reading back through your notes, make sure you’re actively engaging with the material. Passively letting your eyes scan over the material won’t actually help much. Instead, explain the material to yourself, summarize the key points, ask questions, and think about the big picture. Start to plan out how you might want to study the material you learned. If you’ve followed steps 1 and 2, this will be the third time you’re engaging with this content. Repeated exposure to the material helps you remember and understand it more effectively.

<b><br>Step 4: Study</b><br>
Schedule several focused study sessions per week for each of your classes. These sessions don’t have to be long; in fact, brief but intense study sessions tend to be more effective than trying to study for many hours at a time. Figure out how long you can stay focused and efficient—it may be just 20 to 30 minutes, but it will probably vary depending on the material—and then plan study sessions of this length throughout your week. By spreading your studying over time, you’re studying much more effectively (this is called “distributed practice”) and won’t have to try to do less-effective marathon study sessions before the exam (also known as “massed practice”). Distributed practice helps you learn the material at a deeper level because you have more time to process it, see connections, and ask questions.

When you are planning your study sessions, it’s important to set specific and realistic goals. Having a plan for what you’re doing during the study session will help you use your time more efficiently. For more information about how to structure your study sessions check out this handout about intense study sessions. While studying, make sure to use active learning techniques. For example, you could work problems, create a concept map, or explain concepts out loud. In between your short study sessions take a break that will refresh you. After a productive study session, reward yourself.

<b><br>Step 5: Check</b><br>
The last step is the one that a lot of people forget about. It’s important to check in with yourself to make sure what you’re doing is working and being open to changing your techniques if it’s not. After all, you wouldn’t want to spend a lot of time doing something that is not helping you learn. To make sure that your studying is effective, take a step back on a regular basis and ask yourself some metacognitive questions. Practice self-testing on a regular basis. Discuss what you’re learning with classmates. Check in with the learning objectives and make sure you are meeting them.

Want to learn more about the study cycle and create a plan to implement these practices? Make an appointment with an academic coach at the Learning Center to work on this or any of your other academic goals.

 

<li><b>Spacing out is good</b></li>
One of the most impactful learning strategies is “distributed practice”—spacing out your studying over several short periods of time over several days and weeks. 
The most effective practice is to work a short time on each class every day. The total amount of time spent studying will be the same (or less) than one or two 
marathon library sessions, but you will learn the information more deeply and retain much more for the long term—which will help get you an A on the final. 
The important thing is how you use your study time, not how long you study. Long study sessions lead to a lack of concentration and thus a lack of learning 
and retention.

In order to spread out studying over short periods of time across several days and weeks, you need control over your schedule. Keeping a list of tasks to 
complete on a daily basis will help you to include regular active studying sessions for each class. Try to do something for each class each day. Be specific 
and realistic regarding how long you plan to spend on each task—you should not have more tasks on your list than you can reasonably complete during the day.

For example, you may do a few problems per day in math rather than all of them the hour before class. In history, you can spend 15-20 minutes each day actively
studying your class notes. Thus, your studying time may still be the same length, but rather than only preparing for one class, you will be preparing for all of 
your classes in short stretches. This will help focus, stay on top of your work, and retain information.

In addition to learning the material more deeply, spacing out your work helps stave off procrastination. Rather than having to face the dreaded project for four
hours on Monday, you can face the dreaded project for 30 minutes each day. The shorter, more consistent time to work on a dreaded project is likely to be more acceptable and less likely to be delayed to the last minute. Finally, if you have to memorize material for class (names, dates, formulas), it is best to make flashcards for this material and review periodically throughout the day rather than one long, memorization session.

<li><b>It’s good to be intense</b></li>
Not all studying is equal. You will accomplish more if you study intensively. Intensive study sessions are short and will allow you to get work done with minimal wasted effort. Shorter, intensive study times are more effective than drawn out studying.

In fact, one of the most impactful study strategies is distributing studying over multiple sessions. Intensive study sessions can last 30 or 45-minute sessions and include active studying strategies. For example, self-testing is an active study strategy that improves the intensity of studying and efficiency of learning. However, planning to spend hours on end self-testing is likely to cause you to become distracted and lose your attention.

On the other hand, if you plan to quiz yourself on the course material for 45 minutes and then take a break, you are much more likely to maintain your attention and retain the information. Furthermore, the shorter, more intense sessions will likely put the pressure on that is needed to prevent procrastination.

<li><b>Silence isn’t golden</b></li>
Know where you study best. The silence of a library may not be the best place for you. It’s important to consider what noise environment works best for you. You might find that you concentrate better with some background noise. Some people find that listening to classical music while studying helps them concentrate, while others find this highly distracting. The point is that the silence of the library may be just as distracting (or more) than the noise of a gymnasium. Thus, if silence is distracting, but you prefer to study in the library, try the first or second floors where there is more background ‘buzz.’

Keep in mind that active studying is rarely silent as it often requires saying the material aloud.

<li><b>Problems are your friend</b></li>
Working and re-working problems is important for technical courses (e.g., math, economics). Be able to explain the steps of the problems and why they work.

In technical courses, it is usually more important to work problems than read the text. In class, write down in detail the practice problems demonstrated by the professor. Annotate each step and ask questions if you are confused. At the very least, record the question and the answer (even if you miss the steps).

When preparing for tests, put together a large list of problems from the course materials and lectures. Work the problems and explain the steps and why they work (Carrier, 2003).

<li><b>Reconsider multitasking</b></li>
A significant amount of research indicates that multi-tasking does not improve efficiency and actually negatively affects results.

In order to study smarter, not harder, you will need to eliminate distractions during your study sessions. Social media, web browsing, game playing, texting, etc. will severely affect the intensity of your study sessions if you allow them! Research is clear that multi-tasking (e.g., responding to texts, while studying), increases the amount of time needed to learn material and decreases the quality of the learning.

Eliminating the distractions will allow you to fully engage during your study sessions. If you don’t need your computer for homework, then don’t use it. Use apps to help you set limits on the amount of time you can spend at certain sites during the day. Turn your phone off. Reward intensive studying with a social-media break (but make sure you time your break!)

<li><b>Switch up your settin</b></li>g</b></li>
Find several places to study in and around campus and change up your space if you find that it is no longer a working space for you.

Know when and where you study best. It may be that your focus at 10:00 PM. is not as sharp as at 10:00 AM. Perhaps you are more productive at a coffee shop with background noise, or in the study lounge in your residence hall. Perhaps when you study on your bed, you fall asleep.

Have a variety of places in and around campus that are good study environments for you. That way wherever you are, you can find your perfect study spot. After a while, you might find that your spot is too comfortable and no longer is a good place to study, so it’s time to hop to a new spot!

<li><b>Become a teacher</b></li>
Try to explain the material in your own words, as if you are the teacher. You can do this in a study group, with a study partner, or on your own. Saying the material aloud will point out where you are confused and need more information and will help you retain the information. As you are explaining the material, use examples and make connections between concepts (just as a teacher does). It is okay (even encouraged) to do this with your notes in your hands. At first you may need to rely on your notes to explain the material, but eventually you’ll be able to teach it without your notes.

Creating a quiz for yourself will help you to think like your professor. What does your professor want you to know? Quizzing yourself is a highly effective study technique. Make a study guide and carry it with you so you can review the questions and answers periodically throughout the day and across several days. Identify the questions that you don’t know and quiz yourself on only those questions. Say your answers aloud. This will help you to retain the information and make corrections where they are needed. For technical courses, do the sample problems and explain how you got from the question to the answer. Re-do the problems that give you trouble. Learning the material in this way actively engages your brain and will significantly improve your memory.

<li><b>Take control of your calendar</b></li>
Controlling your schedule and your distractions will help you to accomplish your goals.
If you are in control of your calendar, you will be able to complete your assignments and stay on top of your coursework. 
The following are steps to getting control of your calendar:
<ul>
<li>On the same day each week, (perhaps Sunday nights or Saturday mornings) plan out your schedule for the week.</li>
<li>Go through each class and write down what you’d like to get completed for each class that week.</li>
<li>Look at your calendar and determine how many hours you have to complete your work.</li>
<li>Determine whether your list can be completed in the amount of time that you have available. </li>
(You may want to put the amount of time expected to complete each assignment.) Make adjustments as needed. For example, 
if you find that it will take more hours to complete your work than you have available, you will likely need to triage your readings. 
Completing all of the readings is a luxury. You will need to make decisions about your readings based on what is covered in class. </li>
<li>You should read and take notes on all of the assignments from the favored class source (the one that is used a lot in the class). </li>
<li>This may be the textbook or a reading that directly addresses the topic for the day. You can likely skim supplemental readings.</li>
<li>Pencil into your calendar when you plan to get assignments completed.</li>
<li>Before going to bed each night, make your plan for the next day. Waking up with a plan will make you more productive.</li>
<li>Use downtime to your advantage</li>
<li>Beware of ‘easy’ weeks. This is the calm before the storm. Lighter work weeks are a great time to get ahead on work or to start long</li> 
projects. Use the extra hours to get ahead on assignments or start big projects or papers. You should plan to work on every class every week 
even if you don’t have anything due. In fact, it is preferable to do some work for each of your classes every day. Spending 30 minutes per 
class each day will add up to three hours per week, but spreading this time out over six days is more effective than cramming it all in during 
one long three-hour session. If you have completed all of the work for a particular class, then use the 30 minutes to get ahead or start a longer project.
</ul>                
                </ol>
                
                <button class="btn bg-primary mr-auto"> <a href="dashboard.php">Go Back</a></button>
                  <div class="chart tab-pane" id="sales-chart" style="position: relative; height: 300px;">
                    <canvas id="sales-chart-canvas" height="300" style="height: 300px;"></canvas>
                  </div>
                </div>
              </div><!-- /.card-body -->
            </div>
        </div>   
       

            
          
           
            <!-- /.card -->
          </section>
          <!-- right col -->
        </div>
        <!-- /.row (main row) -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
 
 <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<script>
    document.addEventListener("DOMContentLoaded", function(){
  window.addEventListener('scroll', function() {
      if (window.scrollY > 50) {
        document.getElementById('navbar_top').classList.add('fixed-top');
        // add padding top to show content behind navbar
        navbar_height = document.querySelector('.navbar').offsetHeight;
        document.body.style.paddingTop = navbar_height + 'px';
      } else {
        document.getElementById('navbar_top').classList.remove('fixed-top');
         // remove padding top from body
        document.body.style.paddingTop = '0';
      } 
  });
});
</script>

<script src="plugins/jquery/jquery.min.js"></script>
<!-- jQuery UI 1.11.4 -->
<script src="plugins/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button)
</script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- ChartJS -->
<script src="plugins/chart.js/Chart.min.js"></script>
<!-- Sparkline -->
<script src="plugins/sparklines/sparkline.js"></script>
<!-- JQVMap -->
<script src="plugins/jqvmap/jquery.vmap.min.js"></script>
<script src="plugins/jqvmap/maps/jquery.vmap.usa.js"></script>
<!-- jQuery Knob Chart -->
<script src="plugins/jquery-knob/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="plugins/moment/moment.min.js"></script>
<script src="plugins/daterangepicker/daterangepicker.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Summernote -->
<script src="plugins/summernote/summernote-bs4.min.js"></script>
<!-- overlayScrollbars -->
<script src="plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>
</body>
</html>

<script>function display_ct7() {
var x = new Date()
var ampm = x.getHours( ) >= 12 ? ' PM' : ' AM';
hours = x.getHours( ) % 12;
hours = hours ? hours : 12;
hours=hours.toString().length==1? 0+hours.toString() : hours;

var minutes=x.getMinutes().toString()
minutes=minutes.length==1 ? 0+minutes : minutes;

var seconds=x.getSeconds().toString()
seconds=seconds.length==1 ? 0+seconds : seconds;

var month=(x.getMonth() +1).toString();
month=month.length==1 ? 0+month : month;

var dt=x.getDate().toString();
dt=dt.length==1 ? 0+dt : dt;

var x1=month + ":" + dt + ":" + x.getFullYear(); 
x1 = x1 + "  " +  hours + ":" +  minutes + ":" +  seconds + " " + ampm;
document.getElementById('ct7').innerHTML = x1;
display_c7();
 }
 function display_c7(){
var refresh=1000; // Refresh rate in milli seconds
mytime=setTimeout('display_ct7()',refresh)
}
display_c7()
</script>